<?php
session_start();
include 'conexao.php';

// Cadastrar ou alterar
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nome   = trim($_POST['nome'] ?? '');
    $curso  = $_POST['curso'] ?? '';
    $genero = $_POST['genero'] ?? '';
    $idade  = intval($_POST['idade'] ?? 0);
    $lp     = floatval($_POST['lp'] ?? 0);
    $mat    = floatval($_POST['mat'] ?? 0);
    $media  = round(($lp + $mat) / 2, 1);
    $obs    = $media >= 10 ? 'Admitido' : 'Não Admitido';

    if (!empty($_POST['id'])) {
        $id = intval($_POST['id']);
        $stmt = $conn->prepare("UPDATE novos_alunos SET nome=?, curso=?, genero=?, idade=?, lp=?, mat=?, media=?, obs=? WHERE id=?");
        $stmt->bind_param("sssiddssi", $nome, $curso, $genero, $idade, $lp, $mat, $media, $obs, $id);
    } else {
        $stmt = $conn->prepare("INSERT INTO novos_alunos (nome, curso, genero, idade, lp, mat, media, obs) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("sssiddss", $nome, $curso, $genero, $idade, $lp, $mat, $media, $obs);
    }
    $stmt->execute();
    header("Location: cadastrar_novos_alunos.php");
    exit;
}

// Remover aluno
if (isset($_GET['remover'])) {
    $id = intval($_GET['remover']);
    $conn->query("DELETE FROM novos_alunos WHERE id=$id");
    header("Location: cadastrar_novos_alunos.php");
    exit;
}

$lista = $conn->query("SELECT * FROM novos_alunos ORDER BY nome ASC")->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Ver Admissão Geral</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="adminlte/plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="adminlte/dist/css/adminlte.min.css">
  <style>
    body {
        margin: 0;
        font-family: Arial, sans-serif;
        background: #eef1f5;
    }
    .sidebar {
        width: 230px;
        height: 100vh;
        background: #002244;
        position: fixed;
        color: white;
        padding-top: 60px;
    }
    .sidebar h2 {
        text-align: center;
        margin-top: 0;
        font-size: 20px;
        color: #fff;
    }
    .sidebar a {
        display: block;
        padding: 15px 20px;
        color: white;
        text-decoration: none;
        border-bottom: 1px solid #003355;
    }
    .sidebar a:hover {
        background: #004477;
    }
    .topbar {
        background: #002244;
        height: 50px;
        line-height: 50px;
        color: white;
        padding: 0 20px;
        position: fixed;
        left: 230px;
        right: 0;
        top: 0;
    }
    .main {
        margin-left: 230px;
        margin-top: 60px;
        padding: 20px;
    }
    form {
        width: 60%;
        background: white;
        padding: 20px;
        border-radius: 10px;
        box-shadow: 0 0 10px #ccc;
        margin-bottom: 30px;
    }
    input, select {
        width: 100%;
        padding: 8px;
        margin-bottom: 10px;
        border-radius: 6px;
        border: 1px solid #ccc;
    }
    label {
        font-weight: bold;
    }
    button {
        padding: 10px 20px;
        background: #002244;
        color: white;
        border: none;
        border-radius: 6px;
        cursor: pointer;
        margin-right: 10px;
        transition: 0.3s;
    }
    button:hover {
        background: #0056b3;
    }
    table {
        width: 100%;
        border-collapse: collapse;
        background: white;
        box-shadow: 0 0 10px #ccc;
    }
    th, td {
        padding: 8px;
        text-align: center;
        border: 1px solid #ccc;
    }
    th {
        background: #003366;
        color: white;
    }
    .vermelho {
        color: red;
        font-weight: bold;
    }
    td.nome {
        text-align: left;
        font-weight: bold;
    }
    h2, h3 {
        color: #003366;
    }
  </style>
</head>
<body>
<div class="sidebar">
  <h2><i class="fas fa-school"></i> PEFRICKBG0026</h2>
  <a href="painel_secretaria_geral.php"><i class="fas fa-home"></i> Início</a>
  <a href="cadastrar_novos_alunos.php"><i class="fas fa-user-plus"></i> Cadastrar Alunos</a>
  <a href="ver_admissao_geral.php"><i class="fas fa-list"></i> Ver Admissão</a>
  <a href="imprimir_lista.php" target="_blank"><i class="fas fa-print"></i> Imprimir Lista</a>
<a href="imprimir_lista_nominal.php" target="_blank">
  <i class="fas fa-print"></i> Imprimir Lista Nominal
</a>
<a href="ver_turmas_admitidos.php"><i class="fas fa-users"></i> Ver Turmas Admitidos</a>








</div>
<div class="topbar">
  <strong>Sistema de Gestão Escolar</strong>
</div>

<div class="main">
  <h2>Cadastrar Novos Alunos</h2>
  <form method="post">
    <input type="hidden" name="id" id="aluno_id">
    <label>Nome Completo</label>
    <input type="text" name="nome" id="nome" required>

    <label>Curso</label>
    <select name="curso" id="curso" required>
      <option value="">-- Selecione --</option>
      <option value="E.PRIM">E.PRIM</option>
      <option value="E.INF">E.INF</option>
    </select>

    <label>Género</label>
    <select name="genero" id="genero" required>
      <option value="">-- Selecione --</option>
      <option value="Masculino">Masculino</option>
      <option value="Feminino">Feminino</option>
    </select>

    <label>Idade</label>
    <select name="idade" id="idade" required>
      <option value="">-- Selecione --</option>
      <?php for ($i=13; $i<=25; $i++) echo "<option value='$i'>$i</option>"; ?>
    </select>

    <label>Nota L. Portuguesa</label>
    <input type="number" step="0.1" name="lp" id="lp">

    <label>Nota Matemática</label>
    <input type="number" step="0.1" name="mat" id="mat">

    <label>Média</label>
    <input type="text" id="media" disabled>

    <label>Observação</label>
    <input type="text" id="obs" disabled>

    <button type="submit">Cadastrar / Alterar</button>
    <button type="button" onclick="location.href='ver_admissao_geral.php'">Ver Admissão Geral</button>
  </form>

  <h3>Lista de Alunos</h3>
  <table>
    <thead>
      <tr>
        <th>Nº</th>
        <th>Nome</th>
        <th>Curso</th>
        <th>Género</th>
        <th>Idade</th>
        <th>L.Port</th>
        <th>Mat</th>
        <th>Média</th>
        <th>Obs</th>
        <th>Acção</th>
      </tr>
    </thead>
    <tbody>
      <?php $n=1; foreach ($lista as $al): ?>
        <tr>
          <td><?= $n++ ?></td>
          <td class="nome"><?= htmlspecialchars($al['nome']) ?></td>
          <td><?= $al['curso'] ?></td>
          <td><?= $al['genero'] ?></td>
          <td><?= $al['idade'] ?></td>
          <td style="color:<?= $al['lp'] < 10 ? 'red' : 'black' ?>"><?= $al['lp'] ?></td>
          <td style="color:<?= $al['mat'] < 10 ? 'red' : 'black' ?>"><?= $al['mat'] ?></td>
          <td><?= $al['media'] ?></td>
          <td class="<?= $al['obs'] == 'Não Admitido' ? 'vermelho' : '' ?>"><?= $al['obs'] ?></td>
          <td>
            <button onclick='editarAluno(<?= json_encode($al) ?>)'>Editar</button>
            <a href="?remover=<?= $al['id'] ?>" onclick="return confirm('Remover este aluno?')">
              <button style="background:red;">Remover</button>
            </a>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<script>
function editarAluno(aluno) {
  document.getElementById('aluno_id').value = aluno.id;
  document.getElementById('nome').value = aluno.nome;
  document.getElementById('curso').value = aluno.curso;
  document.getElementById('genero').value = aluno.genero;
  document.getElementById('idade').value = aluno.idade;
  document.getElementById('lp').value = aluno.lp;
  document.getElementById('mat').value = aluno.mat;
  document.getElementById('media').value = aluno.media;
  document.getElementById('obs').value = aluno.obs;
}

document.getElementById('lp').addEventListener('input', calcularMedia);
document.getElementById('mat').addEventListener('input', calcularMedia);

function calcularMedia() {
  let lp = parseFloat(document.getElementById('lp').value) || 0;
  let mat = parseFloat(document.getElementById('mat').value) || 0;
  let media = ((lp + mat) / 2).toFixed(1);
  document.getElementById('media').value = media;
  document.getElementById('obs').value = media >= 10 ? 'Admitido' : 'Não Admitido';
  document.getElementById('obs').className = media < 10 ? 'vermelho' : '';
}
</script>
</body>
</html>
